<?php

/* -----------------------------------------------------------------
 * 	$Id: product_master_slave.php 704 2013-11-01 19:00:49Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

$module_smarty = new Smarty;
$module_smarty->assign('tpl_path', 'templates/' . CURRENT_TEMPLATE . '/');
require_once (DIR_FS_INC . 'cseo_get_stock_img.inc.php');
if ($product->data['products_id']) {
    $getSlaveProductsQuery = xtDBquery("SELECT
											p.*,
											pd.*
										FROM
											" . TABLE_PRODUCTS . " p
										LEFT JOIN
											" . TABLE_PRODUCTS_DESCRIPTION . " pd ON(p.products_id = pd.products_id)
										WHERE
											p.products_master_article = '" . $product->data['products_id'] . "'
										AND
											pd.language_id = '" . (int) $_SESSION['languages_id'] . "'
										AND
											p.products_status = '1'
										ORDER BY
											p.products_sort ASC;");

    if (xtc_db_num_rows($getSlaveProductsQuery) > 0) {
        $module_content = array();

        while ($getSlave = xtc_db_fetch_array($getSlaveProductsQuery)) {
            $img = '';
            if (ACTIVATE_SHIPPING_STATUS == 'true') {
                $shippingTimeName = $main->getShippingStatusName($getSlave['products_shippingtime']);
                $shippingTimeImg = $main->getShippingStatusImage($getSlave['products_shippingtime']);
            }
            $products_price = $xtPrice->xtcGetPrice($getSlave['products_id'], true, 1, $getSlave['products_tax_class_id'], $getSlave['products_price'], 1);
            $price = $products_price['formated'];

            if ($getSlave['products_image'] != '') {
                $img = xtc_image(DIR_WS_MINI_IMAGES . $getSlave['products_image'], $getSlave['products_name']);
                $img_info = xtc_image(DIR_WS_INFO_IMAGES . $getSlave['products_image'], $getSlave['products_name']);
                $img_thumb = xtc_image(DIR_WS_THUMBNAIL_IMAGES . $getSlave['products_image'], $getSlave['products_name']);
                $img_popup = DIR_WS_POPUP_IMAGES . $getSlave['products_image'];
                $img_org = DIR_WS_ORIGINAL_IMAGES . $getSlave['products_image'];
            } else {
                $img = xtc_image(DIR_WS_MINI_IMAGES . 'no_img.jpg', $getSlave['products_name']);
                $img_info = xtc_image(DIR_WS_INFO_IMAGES . 'no_img.jpg', $getSlave['products_name']);
                $img_thumb = xtc_image(DIR_WS_THUMBNAIL_IMAGES . 'no_img.jpg', $getSlave['products_name']);
            }

            $tax_rate = $xtPrice->TAX[$getSlave['products_tax_class_id']];
            $tax_info = $main->getTaxInfo($tax_rate);

            $alt_tag = $getSlave['products_image_alt'] != '' ? $getSlave['products_image_alt'] : $getSlave['products_name'];

            if ($getSlave['products_master_article'] != '' && $getSlave['products_slave_in_list'] != '0') {
                $link = xtc_href_link(FILENAME_PRODUCT_INFO, xtc_product_link($getSlave['products_id'], $getSlave['products_name']));
            } else {
                $link = '';
            }
            $module_content[] = array(
                'PRODUCTS_ID' => $getSlave['products_id'],
                'PRODUCTS_NAME' => $getSlave['products_name'],
                'PRODUCTS_WEIGHT' => $getSlave['products_weight'],
                'PRODUCTS_LINK' => $link,
                'PRODUCTS_SHORT_DESC' => $getSlave['products_short_description'],
                'PRODUCTS_PRICE' => $price,
                'PRODUCTS_IMG' => $img,
                'PRODUCTS_IMG_THUMB' => $img_thumb,
                'PRODUCTS_IMG_INFO' => $img_info,
                'PRODUCTS_IMG_POPUP' => $img_popup,
                'PRODUCTS_IMG_ORG' => $img_org,
                'PRODUCTS_TAX' => $tax_info,
                'PRODUCTS_MODEL' => $getSlave['products_model'],
                'PRODUCTS_SHIPPING_LINK' => $main->getShippingLink(),
                'PRODUCTS_STOCK_IMG' => cseo_get_stock_img($getSlave['products_quantity']),
                'HIDDEN_FIELDS' => xtc_draw_hidden_field('products_id[]', $getSlave['products_id']) . xtc_draw_hidden_field('master', $product->data['products_id']),
                'ADD_QTY' => xtc_draw_input_field('products_master_qty[' . $getSlave['products_id'] . ']', '0', 'size="3" class="products_qty" id="qty_' . $getSlave['products_id'] . '"'),
                'SUBMIT_BUTTON' => '<input type="submit" title="' . IMAGE_BUTTON_IN_CART . '" value="' . IMAGE_BUTTON_IN_CART . '" class="css_wk_img_button" onclick="return checkQTY(' . $getSlave['products_id'] . ')">',
                'WISHLIST_BUTTON' => '<a href="' . xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $getSlave['products_id'] . '&action=wishlist') . '" rel="nofollow">' . xtc_image_button('button_to_wish_list.gif', WISHLIST) . '</a>'
            );
        }


        $module_smarty->assign('FORM_START', xtc_draw_form('cart_quantity', xtc_href_link(FILENAME_PRODUCT_INFO, xtc_get_all_get_params(array('action', $product->data['products_id'])) . 'action=add_product'), 'post', 'name="cart_quantity"'));
        $module_smarty->assign('language', $_SESSION['language']);
        $module_smarty->assign('module_content', $module_content);
        $module_smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);

        if (USE_CACHE == 'false') {
            $module_smarty->caching = false;
            $module = $module_smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE . '/module/product_master_slave.html', USE_TEMPLATE_DEVMODE));
        } else {
            $module_smarty->caching = true;
            $module_smarty->cache_lifetime = CACHE_LIFETIME;
            $module_smarty->cache_modified_check = CACHE_CHECK;
            $cache_id = $_SESSION['language'] . $product->data['products_id'] . $_SESSION['customers_status']['customers_status_name'] . 'mastersl';
            $module = $module_smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE . '/module/product_master_slave.html', USE_TEMPLATE_DEVMODE), $cache_id);
        }
        $info_smarty->assign('MODULE_products_master_slave', $module);
    }
}
